#%% Initialize
import rbartz.ecb_control as ecb
import importlib
import time

importlib.reload(ecb)
ecb.ls_number = 3
ecb.verbosity = 0


### Light Source Tests ###

#%% List Light Sources
current_ls_number = ecb.ls_number
for ls_number in range(1, 6):
    ecb.ls_number = ls_number
    idn = ecb.ls_serial_command("*IDN?\r\n").split('\r\n')[0]
    print(f"LS{ecb.ls_number} IDN: '{idn}'")

ecb.ls_number = current_ls_number


#%% Switch LS ON
response = ecb.ls_enable()
print(f"LS{ecb.ls_number} ON: {response}")
time.sleep(0.1)
state = ecb.ls_get_state()
print(f"LS{ecb.ls_number} State: {state}")

#%% Switch LS OFF
response = ecb.ls_disable()
print(f"LS{ecb.ls_number} OFF: {response}")
time.sleep(0.1)
state = ecb.ls_get_state()
print(f"LS{ecb.ls_number} State: {state}")


#%% Toggle LS State
state = ecb.ls_serial_command("SOURCE:AM:STATE?\r\n").split('\r\n')[0]
print(f"Light Source {ecb.ls_number} STATE: '{state}'")
time.sleep(2)
ecb.ls_serial_command("SOURCE:AM:STATE OFF\r\n").split('\r\n')[0]
time.sleep(1)
ecb.ls_serial_command("SOURCE:AM:STATE ON\r\n").split('\r\n')[0]
time.sleep(1)

#%% Toggle LS Supply multiple times
for _ in range(10):
    # Switch LS OFF
    response = ecb.ls_disable()
    print(f"Switch LS{ecb.ls_number} OFF: {response}")
    time.sleep(0.1)
    # Get LS State
    state = ecb.ls_get_state()
    print(f"LS{ecb.ls_number} State: {state}")
    time.sleep(1)

    # Switch LS ON
    response = ecb.ls_enable()
    print(f"Switch LS{ecb.ls_number} ON: {response}")
    time.sleep(0.1)
    # Get LS State
    state = ecb.ls_get_state()
    print(f"LS{ecb.ls_number} State: {state}")
    time.sleep(1)

#%% Test CDRH Commands
state = ecb.ls_serial_command("SOURCE:AM:STATE?\r\n").split('\r\n')[0]
print(f"LS{ecb.ls_number} STATE: '{state}'")
cdrh = ecb.ls_serial_command("SYSTEM:CDRH?\r\n").split('\r\n')[0]
print(f"LS{ecb.ls_number} CDRH: '{cdrh}'")
ecb.ls_serial_command("SYSTEM:CDRH ON\r\n")
cdrh = ecb.ls_serial_command("SYSTEM:CDRH?\r\n").split('\r\n')[0]
print(f"LS{ecb.ls_number} CDRH: '{cdrh}'")


#%% Set Digital Modulation to False
print(f"Set LS{ecb.ls_number} Digital Modulation to False")
ecb.ls_set_digital_modulation(False)

#%% Set Digital Modulation to True
print(f"Set LS{ecb.ls_number} Digital Modulation to True")
ecb.ls_set_digital_modulation(True)


#%% Set Analog Modulation to 0%
print(f"Set LS{ecb.ls_number} Analog Modulation to 0%")
ecb.ls_set_analog_modulation(0.0)

#%% Set Analog Modulation to 50%
print(f"Set LS{ecb.ls_number} Analog Modulation to 50%")
ecb.ls_set_analog_modulation(50.0)

#%% Set Analog Modulation to 100%
print(f"Set LS{ecb.ls_number} Analog Modulation to 100%")
ecb.ls_set_analog_modulation(100.0)


### Scan Unit DAC Tests ###

#%% Set DAC of Light Source to 0
print(f"Set DAC of LS{ecb.ls_number} to 0")
ecb.su_set_dac_value(channel=ecb.ls_number, value=0)

#%% Set DAC of Light Source to 2048
print(f"Set DAC of LS{ecb.ls_number} to 2048")
ecb.su_set_dac_value(channel=ecb.ls_number, value=2048)

#%% Set DAC of Light Source to 4095
print(f"Set DAC of LS{ecb.ls_number} to 4095")
ecb.su_set_dac_value(channel=ecb.ls_number, value=4095)


#%% Pulse Trigger of Light Source
duration_ms = 2000
print(f"Pulse LS{ecb.ls_number} Trigger for {duration_ms} ms")
ecb.su_trigger_pulse(channel=ecb.ls_number, duration_ms=duration_ms)

#%% Pulse Trigger of Camera
duration_ms = 2000
camera = 1  # Camera 1 to 4 are channels 9 to 12
print(f"Pulse CAM{camera} Trigger for {duration_ms} ms")
ecb.su_trigger_pulse(channel=(camera + 8), duration_ms=duration_ms)


#%% Measure Auto Focus scan time
length = 5000
print(f"Start Auto Focus scan with length {length}")
start_time = time.perf_counter()
response = ecb.su_start_af_scan(max_len=length)
end_time = time.perf_counter()
scan_samples = response['scan_samples']
print(f"Scan Samples: {scan_samples}")
print(f"Auto Focus scan completed in {end_time - start_time:.3f} seconds and received {len(scan_samples)} samples.")


### CAN Bus Tests ###

# %% Get ECB Status via CAN
response = ecb.can_get_status()
print(f"Status: {response['status']}, Error: {response['error']}")


# %% Enable Shaker
frequency_hz = 1000
print(f"Enable Shaker at {frequency_hz} Hz")
ecb.can_set_shaker(frequency_hz)
ecb.can_set_pwm_output(output=3, switch_current=0, hold_current=0, switch_time_ms=0)
ecb.can_set_pwm_output(output=2, switch_current=100, hold_current=100, switch_time_ms=2000)

#%% Disable Shaker
print("Disable Shaker")
ecb.can_set_pwm_output(output=2, switch_current=0, hold_current=0, switch_time_ms=0)


# %%
